/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.projecte;

import com.mojang.datafixers.util.Either;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.providers.IInfuseTypeProvider;
import moze_intel.projecte.api.nss.AbstractNSSTag;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import net.minecraft.core.HolderSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraftforge.registries.tags.ITag;

public final class NSSInfuseType
extends AbstractNSSTag<InfuseType> {
    private NSSInfuseType(@Nonnull ResourceLocation resourceLocation, boolean isTag) {
        super(resourceLocation, isTag);
    }

    @Nonnull
    public static NSSInfuseType createInfuseType(@Nonnull InfusionStack stack) {
        return NSSInfuseType.createInfuseType((InfuseType)stack.getType());
    }

    @Nonnull
    public static NSSInfuseType createInfuseType(@Nonnull IInfuseTypeProvider infuseTypeProvider) {
        return NSSInfuseType.createInfuseType((InfuseType)infuseTypeProvider.getChemical());
    }

    @Nonnull
    public static NSSInfuseType createInfuseType(@Nonnull InfuseType infuseType) {
        if (infuseType.isEmptyType()) {
            throw new IllegalArgumentException("Can't make NSSInfuseType with an empty infuse type");
        }
        return NSSInfuseType.createInfuseType(infuseType.getRegistryName());
    }

    @Nonnull
    public static NSSInfuseType createInfuseType(@Nonnull ResourceLocation infuseTypeID) {
        return new NSSInfuseType(infuseTypeID, false);
    }

    @Nonnull
    public static NSSInfuseType createTag(@Nonnull ResourceLocation tagId) {
        return new NSSInfuseType(tagId, true);
    }

    @Nonnull
    public static NSSInfuseType createTag(@Nonnull TagKey<InfuseType> tag) {
        return NSSInfuseType.createTag(tag.f_203868_());
    }

    protected boolean isInstance(AbstractNSSTag o) {
        return o instanceof NSSInfuseType;
    }

    @Nonnull
    public String getJsonPrefix() {
        return "INFUSE_TYPE|";
    }

    @Nonnull
    public String getType() {
        return "Infuse Type";
    }

    @Nonnull
    protected Optional<Either<HolderSet.Named<InfuseType>, ITag<InfuseType>>> getTag() {
        return this.getTag(MekanismAPI.infuseTypeRegistry());
    }

    protected Function<InfuseType, NormalizedSimpleStack> createNew() {
        return NSSInfuseType::createInfuseType;
    }
}

